﻿namespace HIPS.Web.UI.ViewModels.PcehrView
{

    /// <summary>
    /// View model for a document category.
    /// </summary>
    /// <history>
    ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
    /// </history>
    public class DocumentCategoryViewModel
    {

        #region Properties

        /// <summary>
        /// Gets the auto-generated unique identifier for the document category.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public string CategoryUniqueId { get; private set; }

        /// <summary>
        /// Gets or sets the code for the document category.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public string CategoryCode { get; set; }

        /// <summary>
        /// Gets or sets the name of the document category.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets a value that indicates if service dates are relevant to the document category.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public bool AreServiceDatesRelevant { get; set; }

        /// <summary>
        /// Gets or sets the count of documents belonging to the document category.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public int Count { get; set; }

        #endregion

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <history>
        ///   <change user="David Sampson (Chamonix)" date="26 November 2013">Initial version.</change>
        /// </history>
        public DocumentCategoryViewModel()
        {
            this.CategoryUniqueId = System.Guid.NewGuid().ToString();
        }

        #endregion

    }

}